/*
** Source Lines of Code Counter      (c) Copyright IBM Corp., 1987, 1992
**                                   For Internal Use Only
**    by: Jeffrey W. Hamilton  (JEFFH at WMAVM7)
*/

/*
** Note:
** If you are compiling this code with IBM C/370 you must define CC_C370
** on the command line for the compiler.
**
** If you are compiling with IBM C/2 1.1 and are targeting OS/2, you must
** define OS_OS2 on the command line for the compiler.
*/
#define INCL_STDIO
#define INCL_STDLIB
#define INCL_STRING
#define INCL_CTYPE
#define INCL_ERRNO
#include "libibm.h"
#include "regex.h"

/* Fold libibm's names into a more managable subset */
#if defined(OS_OS2_2)
#if !defined(OS_OS2)
#define OS_OS2
#endif

#elif (defined(OS_AIX1_2) || defined(OS_AIX3_0) || defined(OS_AIX3_1) || defined(OS_AIX3_2))
#if !defined(OS_AIX)
#define OS_AIX
#endif

#endif

#define VERSION "4.2"

#if defined(OS_OS2)

#include <io.h>
/* Pick up OS/2 Toolkit includes */
#define INCL_DOS
#include <os2.h>

#define DISKNAME_LIMIT 2
#define PATHNAME_LIMIT 128
#define FILENAME_LIMIT 128
#define EXTENSION_LIMIT 128
#define FULLNAME_LIMIT 128

#elif defined(OS_DOS)

#include <io.h>
#include <dos.h>
#include <dir.h>

#define DISKNAME_LIMIT 2
#define PATHNAME_LIMIT 80
#define FILENAME_LIMIT 8
#define EXTENSION_LIMIT 3
#define FULLNAME_LIMIT (DISKNAME_LIMIT+PATHNAME_LIMIT+FILENAME_LIMIT+EXTENSION_LIMIT+2)

#elif defined(OS_AIX)

#define DISKNAME_LIMIT 2
#define PATHNAME_LIMIT 128
#define FILENAME_LIMIT 128
#define EXTENSION_LIMIT 128
#define FULLNAME_LIMIT 128

#elif defined(OS_MVS)

#define DISKNAME_LIMIT 2
#define PATHNAME_LIMIT 128
#define FILENAME_LIMIT 8
#define EXTENSION_LIMIT 8
#define FULLNAME_LIMIT 128

#elif defined(OS_VM)

#define DISKNAME_LIMIT 2
#define PATHNAME_LIMIT 1
#define FILENAME_LIMIT 8
#define EXTENSION_LIMIT 8
#define FULLNAME_LIMIT (FILENAME_LIMIT+EXTENSION_LIMIT+DISKNAME_LIMIT+2)

#endif

typedef struct {
  unsigned char type;           /* 0=free form, 1=start, 2=field, 3=column */
  unsigned char position;       /* initial position */
  re_prog_t *expression;        /* Expression matching function */
} sym_marker;

typedef struct SYM_PAIR {
  struct SYM_PAIR *next;        /* next set of markers */
  sym_marker start;
  sym_marker end;
  int nestable;                 /* 0=no 1=yes */
} sym_pair;

typedef struct ALT_MODE {
  struct ALT_MODE *next;      /* Next alternative mode */
  sym_pair *alternate;        /* Markers that flag this mode */
  sym_pair *comment;          /* Comment markers */
  sym_pair *ignore;           /* Skip over markers */
  sym_pair *escape;           /* escape character */
  sym_pair *line;             /* line termination markers */
  sym_pair *view;             /* restricted view markers */
  sym_pair *cont_next;        /* continuation on next line marker */
  sym_pair *cont_prev;        /* continuation from previous line marker */
} alt_mode;

typedef struct DESCRIPTION {
  struct DESCRIPTION *next;   /* next description in list */
  re_prog_t *ext;             /* extension matching program */
  alt_mode *mode;             /* description in each mode */
} description;

typedef struct SYM_LIST {
  struct SYM_LIST *next;      /* next element in list */
  char *name;                 /* filename, including path */
  unsigned int  lines;        /* number of physical lines in file */
  unsigned int  comments;     /* number of comments in file */
  unsigned int  code;         /* number of source code statements in file */
} sym_list;

extern int  debug;
extern int  recurse;
extern int  detailed;
extern int  brief;
extern description *descr;
extern sym_list *counts;
extern FILE *output;
#if defined(OS_VM) || defined(OS_MVS)
#pragma map (total_lines,"totallin")
#pragma map (total_comments,"totalcom")
#pragma map (total_code,"totalcod")
#pragma map (profile_fn,"proffn")
#pragma map (print_instructions,"prtinst")
#pragma map (output_fn,"outfn")
#pragma map (report_fn,"repfn")
#pragma map (build_profile,"bldprof")
#pragma map (build_list,"bldlst")
#pragma map (record_count,"reccnt")
#pragma map (total_files,"totalfil")
#pragma map (print_report,"prtrep")
#pragma map (check_space,"chksp")
#pragma map (findfirst,"find1st")
#pragma map (parse_extension,"parext")
#pragma map (parse_pair,"parpair")
#pragma map (parse_marker,"parmark")
#pragma map (parse_position,"parpos")
#pragma map (unanchored_match,"unancmat")
#pragma map (anchored_match,"ancmat")
#pragma map (at_line_start,"atlinst")
#pragma map (srh_compile,"srhcomp")
#pragma map (srh_search,"srhsrch")
#pragma map (srh_destroy,"srhdstry")
#endif
extern unsigned total_files;
extern unsigned long total_lines;
extern unsigned long total_comments;
extern unsigned long total_code;
extern char buffer[512];

void check_space(void *);
void build_profile(FILE *);
sym_list *build_list(char *);
void record_count(sym_list *);
void print_report(FILE *);
int match(char *,char *);
void print_instructions(char *progname);
description *parse_extension(FILE *profile);
sym_pair *parse_pair(char **pos);
void parse_position(char *string, sym_marker *marker);
void parse_marker(char **pos, sym_marker *marker);
char *strnparse(char *target, char *source, char *terms, int length);
char *strmatch(char *source, char *target);
FILE *xfopen(char *fname, char *fmode);
#if defined(OS_AIX) || defined(OS_OS2)
void fnsplit(char *name, char *drive, char *dir, char *filename, char *extension);
#endif
#if defined(OS_AIX) || defined(OS_VM) || defined(OS_MVS)
char *strupr(char *);
char *strdup(char *);
#endif

#if defined(OS_VM) || defined(OS_MVS)
#define ENOENT 10
#endif

#define strip_blanks(x) (x) += strspn(x," \t\n")
#define FREE_FORM 0
#define AT_START  1
#define FIELD     2
#define COLUMN    3
#define AT_LINE_START 4
